﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SWAT_Office_App
{
    public partial class Delete_User_Verify_Form : Form
    {
        private List<string> selectedUsers = new List<string>();
        public Delete_User_Verify_Form(List<string> users)
        {
            selectedUsers = users;
            InitializeComponent();
            this.txt_Password.Focus();

            // Monitors the text in each textbox, triggering changes when certain criteria is met
            this.txt_Password.TextChanged += new EventHandler(this.txt_Password_TextChanged);
        }
        private void txt_Password_TextChanged(object sender, EventArgs e)
        {
            TextBox tb = (TextBox)sender;
            if (tb.Text == Settings_Form.globalAdminPassword)
            {
                bool error = false;
                // Checks if any of the selected items are system accounts
                foreach (string user in selectedUsers)
                {
                    foreach (string systemUser in Settings_Form.systemAccounts)
                    {
                        if (user.ToLower() == systemUser.ToLower())
                        {
                            MessageBox.Show("Cannot delete the " + systemUser + " (system) account", "Error");
                            error = true;
                        }
                    }
                }
                if (error == false)
                    if (!Manage_User_Accounts.DeleteUser(selectedUsers))
                    {
                        Debug.appendText("Error occured when trying to delete user");
                        MessageBox.Show("Error occured when trying to delete user", "Error");
                    }
                this.Close();
            }
        }
        private void btn_Cancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
